require 'rspec'
require 'rubygems'
require 'watir-webdriver'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../helper/modal'
require_relative '../../pages/base/base'
require_relative '../../pages/base/login'
require_relative '../../common/common'
require_relative '../../pages/varUtility/manage_settings'
require_relative '../../module/DateUtility'
require_relative '../../helper/table'
require_relative '../../pages/varUtility/error_validation'
require_relative '../../pages/varUtility/manage_settings/direct_scheduling'
require_relative '../../pages/varUtility/manage_settings/custom_messages'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/landing_page'
require_relative '../../common/accessVarUtility'

require 'vaToolSet/vaToolSet_pageObject'
require_relative '../../common/accessVarUtility'

describe '[VARUT-1647: Authorized User - Change Location Feature' do

  include DriverUtility
  include DateUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @login = Login.new(@driver)
    @landing = Landing.new(@driver)
    @home = Home.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @direct_scheduling = Direct_Scheduling.new(@driver)
    @request_setting = Request_Settings.new(@driver)
    @custom_messages = Custom_Messages.new(@driver)
    @landing_page = LandingPage.new(@driver)
    @table = Table.new(@driver)
    @error = Error_Validation.new(@driver)
    @modal = Modal.new(@driver)

    @vts_po  = VaToolSet_PageObject.new(@driver)

    @vts_po.loginLogout.login(UserAccess7)
    #Access VAR Utility
    @home.varUtilOpen_element.wait_until_present(TIME_OUT_LIMIT)
    @home.varUtilOpen

  end

  after(:all) do
    @driver.close
  end

  context '[AC#VARUT-1762|TC#VARUT-1763: Authorized User - Change Location Feature]' do |selected_facility|
    it 'Login and navigate to Var Utility Welcome Page' do
      selected_facility = 'BOSTON HCS VAMC'
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value(selected_facility)
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings
      @vts_po.landing.new_welcome_message_element.when_visible(TIME_OUT_LIMIT)
    end

    it 'Verify change location Modal' do
      @manage_setting.change_location
      @manage_setting.changeLocationModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@manage_setting.changeLocationModalTitle).to eq("Popup modal\nChange Location")
      #expect(@manage_setting.changeLocationModalContent).to eq("Select a facility location under #{selected_facility}\nFacility Location:\nBOSTON HCS VAMC\nLIVINGSTON CBOC\nNHCU CANANDAIGUA\nSARRTP Buffalo, NY")

    end

    it "Verify Facility List" do

      expected_content =[\
                         "ZZBOSTON NURSING HOME",
                         "ZZ-DORCHESTER",
                         "WORCESTER",
                         "WEST ROXBURY",
                         "QUINCY",
                         "PLYMOUTH CBOC",
                         "LOWELL OPC",
                         "IDES HANSCOM AFB",
                         "FRAMINGHAM",
                         "CHELSEA",
                         "BROCKTON VAMC",
                         "BROCKTON DOM",
                         "BOSTON VA MOBILE CLINIC",
                         "BOSTON VA FACILITY DOM",
                         "BOSTON SPINAL CORD OUTCOMES",
                         "BOSTON SOC",
                         "BOSTON PRRTP",
                         "BOSTON HCS VAMC"
      ]

      actual_content = @landing_page.change_location_list_options
      p actual_content
      compareContents(expected_content, actual_content)
    end

    it 'Verify switch to new facility location' do
      parent_facility = 'BOSTON HCS VAMC'
      selected_facility = 'BOSTON HCS VAMC'
      @landing_page.changeLocation(selected_facility)
      sleep 1
      expect(@manage_setting.changeLocationModalContent).to include("Select a facility location under #{parent_facility}\nFacility Location:")
      @landing_page.changeLocationViewSettings
      @landing_page.detail_panel_text_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.detail_panel_text_element.text).to eq("Welcome\nWelcome SEVEN PROVIDER\n#{@landing_page.getLocalDate}\nYou are viewing settings for:\n#{selected_facility}\nNote that any changes to this location's settings affect all clinics associated with this location.")
      sleep 2
      selected_facility = 'BROCKTON VAMC'
      @manage_setting.change_location
      @manage_setting.changeLocationModalTitle_element.when_visible(TIME_OUT_LIMIT)
      @landing_page.changeLocation(selected_facility)
      sleep 1
      expect(@manage_setting.changeLocationModalContent).to include("Select a facility location under #{parent_facility}\nFacility Location:")
      @landing_page.changeLocationViewSettings
      sleep 2
      @landing_page.detail_panel_text_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.detail_panel_text_element.text).to eq("Welcome\nWelcome SEVEN PROVIDER\n#{@landing_page.getLocalDate}\nYou are viewing settings for:\n#{selected_facility}\nNote that any changes to this location's settings affect all clinics associated with this location.")
      sleep 2
      selected_facility = 'FRAMINGHAM'
      @manage_setting.change_location
      @manage_setting.changeLocationModalTitle_element.when_visible(TIME_OUT_LIMIT)
      @landing_page.changeLocation(selected_facility)
      sleep 1
      expect(@manage_setting.changeLocationModalContent).to include("Select a facility location under #{parent_facility}\nFacility Location:")
      @landing_page.changeLocationViewSettings
      sleep 2
      @landing_page.detail_panel_text_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.detail_panel_text_element.text).to eq("Welcome\nWelcome SEVEN PROVIDER\n#{@landing_page.getLocalDate}\nYou are viewing settings for:\n#{selected_facility}\nNote that any changes to this location's settings affect all clinics associated with this location.")
      sleep 2
    end

    it 'Verify default seleted facility and user can cancel successfuly out of change location' do

      existing_location = @landing_page.home_facility_element.text
      @manage_setting.change_location
      @manage_setting.changeLocationModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@manage_setting.facility_location).to eq(existing_location)
      @landing_page.cancelChangeFacility(1)
      @landing_page.detail_panel_text_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@landing_page.detail_panel_text_element.text).to eq("Welcome\nWelcome SEVEN PROVIDER\n#{@landing_page.getLocalDate}\nYou are viewing settings for:\n"+existing_location+"\nNote that any changes to this location's settings affect all clinics associated with this location.")
      sleep 2
    end

    it 'Verify continue without save pop up for unsaved changes for direct scheduling on change location' do
      @manage_setting.clickOption('Direct Scheduling')
      expect(@landing.primary_header).to eq("Direct Scheduling")
      Watir::Wait.until {@table.tableList_elements.length > 1}
      @direct_scheduling.audiology = "Yes - Based Upon Time Frame"
      @direct_scheduling.audiologyLastSeen = "24 months (730 days)"
      @manage_setting.change_location
      expect(@modal.modalTitle).to include("Confirmation")
      expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      @modal.ok
      @manage_setting.changeLocationModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@manage_setting.changeLocationModalTitle).to eq("Popup modal\nChange Location")
      @landing_page.changeLocationCancelButton
    end

    it 'Verify continue without save pop up for unsaved changes for Requests on change location' do
      sleep 2
      @manage_setting.clickOption('Requests')
      @request_setting.primaryCare_element.when_present(TIME_OUT_LIMIT)
      @request_setting.primaryCare = "Yes - Any Veteran"
      @manage_setting.change_location
      expect(@modal.modalTitle).to include("Confirmation")
      expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      @modal.ok
      @manage_setting.changeLocationModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@manage_setting.changeLocationModalTitle).to eq("Popup modal\nChange Location")
      @landing_page.changeLocationCancelButton
      sleep 2
    end

    it 'Verify continue without save pop up for unsaved changes for Custom Messages on change location' do
      @manage_setting.clickOption("Custom Text")
      expect(@landing.primary_header).to eq("Custom Text")
      @custom_messages.displayText= "Custom Message Should be Entered Here"
      @manage_setting.change_location
      expect(@modal.modalTitle).to include("Confirmation")
      expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      @modal.ok
      @manage_setting.changeLocationModalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@manage_setting.changeLocationModalTitle).to eq("Popup modal\nChange Location")
      @landing_page.changeLocationCancelButton
    end
  end

end